#!/usr/bin/env python
#=====================
# Menu window
# By QB89Dragon 2007/8
#=====================
import sys
import pygtk
pygtk.require("2.0")
import gtk
import gtk.glade
import Images
import cairo
import pango
import os
import gconf
import string
from Cairo_Window import CairoWindow
#Dynamically import selected theme module
exec "sys.path.append('"+Images.ProgramDirectory+"PGMenu/"+Images.PGTheme+"/')"
exec "from PGMenu import ProgramList"

class Main_Menu:
    def __init__(self):
		if Images.EnableCompositing==1:
			# Set up the user icon
			self.usericon = CairoWindow(Images.IconW,Images.IconH,Images.IconInX,Images.IconInY,Images.IconInW,Images.IconInH)
			self.usericonstate = 0
			self.LastUserPicName = ""
		#Set the main working directory to home
		os.chdir(Images.HomeDirectory)
		#Set the Glade file
		self.wTree = gtk.glade.XML(Images.GladeFile)
		self.window = self.wTree.get_widget("MainMenu")
		self.window.set_app_paintable(1)
		self.window.set_skip_taskbar_hint(1)
		self.window.set_skip_pager_hint(1)
		self.window.set_keep_above(0)       #Make this always above other windows
		self.window.stick()                 #Make this appear on all desktops

		#Get the Main Window, and connect the "destroy" event
		if (self.window):
			dic = {"on_MainMenu_destroy_event" : gtk.main_quit}
			self.wTree.signal_autoconnect(dic)
			self.window.connect("focus-out-event", self.internal_destroy)
			self.window.connect("key-press-event", self.key_down)
		    
    def auxdestroyed(self):
        #dummy sub for module compatibility
        pass
    
    def destroy(self):
        # External Obliterator
        if Images.EnableCompositing == 1:
            self.usericon.destroy(None)
        self.window.destroy()
        gtk.main_quit()
        
    def internal_destroy(self,widget,event):
        # Internal Obliterator (event driven)
        if Images.EnableCompositing == 1:
            self.usericon.destroy(None)
	self.window.destroy()
        gtk.main_quit()

#=================================================================
#WINDOW SETUP
#=================================================================

    def setup(self,win_x, win_y):
		#Standard setup of window
		tmp = self.window.get_size()
		win_x = win_x + Images.StartMenuXOffset
		# Change from beta 1, make it go down if in the top part of the screen
		# May want to adjust theme to make it look prettier when doing this tho
		#screen = gtk.gdk.screen_get_default()
		self.screenmidpty = int(Images.screenheight / 2)
		if win_y < self.screenmidpty:
			win_y = win_y - Images.StartMenuYOffset
		else:
			win_y = win_y - tmp[1] + Images.StartMenuYOffset
		self.win_x = win_x
		self.win_y = win_y
		self.window.move(win_x, win_y)
		
		# Set up the UserPic
		self.ChangeUserPic_Normalise()

		# Set menu background image
		self.background =  self.wTree.get_widget("Background")

		# Set window shape from alpha mask of background image
		self.bgpb = gtk.gdk.pixbuf_new_from_file(Images.StartMenuTemplate)
		self.bgpbim, self.bgpbms = self.bgpb.render_pixmap_and_mask(alpha_threshold=128)
		self.background.set_from_pixmap(self.bgpbim, self.bgpbms)

		#self.window.input_shape_combine_mask(self.bgpbms,0,0)
		self.window.shape_combine_mask(self.bgpbms, 0, 0)

		#Set event for searchbar
		if Images.MenuHasSearch:
			self.SearchBar =  self.wTree.get_widget("SearchBar")
			self.SearchBar.connect("activate",self.SearchBarActivate)
			self.SearchBar.connect("key-release-event",self.SearchBarActivate)
		

		#SET CUSTOM BUTTON DEFAULT IMAGES
		self.Setimage(Images.PowerButton, "PowerButtonImage")
		if Images.MenuHasLock:
			self.Setimage(Images.LockButton, "LockButtonImage")
		if Images.MenuHasAux:
			self.Setimage(Images.AuxButton, "AuxButtonImage")
		#Power Button
		self.Button =  self.wTree.get_widget("PowerButton")
		self.Button.connect("enter-notify-event", self.PowerButton_enter)
		self.Button.connect("leave-notify-event", self.PowerButton_leave)
		self.Button.connect("button-release-event", self.PowerButton_click)
		#Lock Button
		if Images.MenuHasLock:
			self.Button =  self.wTree.get_widget("LockButton")
			self.Button.connect("enter-notify-event", self.LockButton_enter)
			self.Button.connect("leave-notify-event", self.LockButton_leave)
			self.Button.connect("button-release-event", self.LockButton_click)
		#Aux Button
		if Images.MenuHasAux:
			self.Button =  self.wTree.get_widget("AuxButton")
			self.Button.connect("enter-notify-event", self.AuxButton_enter)
			self.Button.connect("leave-notify-event", self.AuxButton_leave)
			self.Button.connect("button-release-event", self.AuxButton_click)

		#Right hand Menu Buttons
		for i in range(0,Images.MenuButtonCount):
			self.AddCustomButton(i)
			
		# Configure the Program List
		self.PGL = ProgramList()
		self.PGL.ProgramListPopulate(self.wTree.get_widget("MenuFrame"), self.internal_destroy)

		# Pass widget focus to the text entry box
		if Images.MenuHasSearch:
			self.SearchBar =  self.wTree.get_widget("SearchBar")
	
		self.window.present()
                
    def key_down (self,widget,event):
        # Key down
        key = event.hardware_keycode
        if key == 9:
            #Escape Key, nukes window
            self.internal_destroy(None,None)
            
#=================================================================
#POWER BUTTON EVENTS
#=================================================================
    def PowerButton_enter(self,widget,event):
        self.Setimage(Images.PowerButtonSel, "PowerButtonImage")
    def PowerButton_leave(self,widget,event):
        self.Setimage(Images.PowerButton, "PowerButtonImage")
    def PowerButton_click(self,widget,event):
        os.spawnvp(os.P_NOWAIT,"gnome-session-save",["gnome-session-save", "--kill"])
        self.internal_destroy(None,None)
#=================================================================
#LOCK BUTTON EVENTS
#=================================================================
    def LockButton_enter(self,widget,event):
        self.Setimage(Images.LockButtonSel, "LockButtonImage")
    def LockButton_leave(self,widget,event):
        self.Setimage(Images.LockButton, "LockButtonImage")
    def LockButton_click(self,widget,event):
        os.spawnvp(os.P_NOWAIT,"gnome-screensaver-command",["gnome-screensaver-command", "--lock"])
        self.internal_destroy(None,None)
#=================================================================
#AUX BUTTON EVENTS
#=================================================================
    def AuxButton_enter(self,widget,event):
        self.Setimage(Images.AuxButtonSel, "AuxButtonImage")
    def AuxButton_leave(self,widget,event):
        self.Setimage(Images.AuxButton, "AuxButtonImage")
    def AuxButton_click(self,widget,event):
        self.PGL.CallSpecialMenu(3)
#=================================================================
#Right Hand Side panel
#=================================================================

    def RPanelBar_enter(self,widget,event):
		# Called when the mouse enters an event box
		if widget.name != Images.M_CurrentIconSet:
			self.Setvisable(Images.M_CurrentIconSet, False)
		Images.M_CurrentIconSet = widget.name
		self.Setvisable(Images.M_CurrentIconSet, True)

		if Images.EnableCompositing == 1 and Images.MenuHasFade == 1:
			self.UserPicName = self.RMenuImageLookup(Images.M_CurrentIconSet,1)
			if self.LastUserPicName!=self.UserPicName:
				self.LastUserPicName=self.UserPicName
				#self.usericon.iconopacity = [0,0,1,0]
				if self.usericonstate == 0:
					self.usericon.transition([-1,-1,1,0],Images.TransitionS,Images.TransitionQ,None)
					self.usericon.updateimage(2,self.UserPicName)
				elif self.usericonstate == 1:
					self.usericon.updateimage(3,self.UserPicName)
					self.usericon.transition([-1,-1,-1,1],Images.TransitionS,Images.TransitionQ,None)
				elif self.usericonstate == 2:
					self.usericon.updateimage(2,self.UserPicName)
					self.usericon.transition([-1,-1,1,-1],Images.TransitionS,Images.TransitionQ,None)
				if self.usericonstate == 1:
					self.usericonstate = 2
				else:
					self.usericonstate = 1

				
    def RPanelBar_leave(self,widget,event):     #Called when the mouse leaves an event box
        self.LeaveCustomState()
        
    def RPanelBar_click(self,widget,event):
        # Called in response to a click in an event box
        print widget.name + " called click event"
        self.closewin = self.RMenuFunctionLookup(widget.name)
        if self.closewin == 0:
            self.internal_destroy(None,None)
    	
    def RMenuFunctionLookup(self,widgetname):
		if widgetname=="M_Home":
			self.k = Images.Actions[0]
		elif widgetname=="M_Documents":
			self.k = Images.Actions[1]
		elif widgetname=="M_Pictures":
			self.k = Images.Actions[2]
		elif widgetname=="M_Music":
			self.k = Images.Actions[3]
		elif widgetname=="M_Games":
			self.k = Images.Actions[4]
		elif widgetname=="M_Search":
			self.k = Images.Actions[5]
		elif widgetname=="M_RecentItems":
			self.PGL.CallSpecialMenu(4)
			return 1
		elif widgetname=="M_Computer":
			self.k = Images.Actions[6]
		elif widgetname=="M_Network":
			self.k = Images.Actions[7]
		elif widgetname=="M_Connect":
			self.k = Images.Actions[8]
		elif widgetname=="M_ControlPanel":
			self.k = Images.Actions[9]
		elif widgetname=="M_Defaults":
			self.k = Images.Actions[10]
		elif widgetname=="M_Help":
			self.k = Images.Actions[11]
		self.k = string.replace(self.k, "[home]", Images.HomeDirectory)
		self.kp = self.k.split()
		os.spawnvp(os.P_NOWAIT,self.kp[0],self.kp)
		return 0
        
    def RMenuImageLookup(self,widgetname, sel):
        if widgetname=="M_Home":return Images.M_Home[sel]
        if widgetname=="M_Documents":return Images.M_Documents[sel]
        if widgetname=="M_Pictures":return Images.M_Pictures[sel]
        if widgetname=="M_Music":return Images.M_Music[sel]
        if widgetname=="M_Games":return Images.M_Games[sel]
        if widgetname=="M_Search":return Images.M_Search[sel]
        if widgetname=="M_RecentItems":return Images.M_RecentItems[sel]
        if widgetname=="M_Computer":return Images.M_Computer[sel]
        if widgetname=="M_Network":return Images.M_Network[sel]
        if widgetname=="M_Connect":return Images.M_Connect[sel]
        if widgetname=="M_ControlPanel":return Images.M_ControlPanel[sel]
        if widgetname=="M_Defaults":return Images.M_Defaults[sel]
        if widgetname=="M_Help":return Images.M_Help[sel]
                
    def AddCustomButton(self,i):
        self.Button =  self.wTree.get_widget(Images.MenuButtonWidgets[i])
        self.Button.connect("enter-notify-event", self.RPanelBar_enter)
        self.Button.connect("leave-notify-event", self.RPanelBar_leave)
        self.Button.connect("button-release-event", self.RPanelBar_click)
        self.Setimage(Images.ImageDirectory + Images.MenuButtonIcons[i],Images.MenuButtonWidgets[i] + "Image")
        self.Setvisable(Images.MenuButtonWidgets[i],False)
        self.Label = gtk.Label("hello")
        self.Button.add(self.Label)
#=================================================================
#GLADE METHODS
#=================================================================
    #Set an image from a png file
    def Setimage(self,imagefile,gladename):
        self.Pic = gtk.gdk.pixbuf_new_from_file(imagefile)
        self.ImageObject =  self.wTree.get_widget(gladename)
        self.ImageObject.set_from_pixbuf(self.Pic)

    #Set visibility of an event box object
    def Setvisable(self,gladename, visibility):
        self.ImageObject =  self.wTree.get_widget(gladename)
        if self.ImageObject:
            self.ImageObject.set_visible_window(visibility)

    def LeaveCustomState(self):
        self.Setvisable(Images.M_CurrentIconSet, False)
        if Images.EnableCompositing == 1:
            self.ChangeUserPic_Normalise()

    def ChangeUserPic_Normalise(self):
        # Restore userpic to mode 2  (speed lag if overwriting already current values)
        # Place the usericon        
        if Images.EnableCompositing == 1:
			self.usericon.move(self.win_x + Images.UserIconFrameOffsetX,self.win_y  + Images.UserIconFrameOffsetY)
			self.usericon.updateimage(0,Images.UserImageFrame)
			self.usericon.updateimage(1,Images.UserImage)
			#self.usericon.iconopacity = [1,1,0,0]
			self.usericon.transition([1,1,-1,-1],Images.TransitionS,Images.TransitionQ,None)
			self.usericonstate == 0
			self.LastUserPicName = ""
			self.usericon.Redraw()
            
#=================================================================
#SEARCH BAR
#=================================================================
    def SearchBarActivate(self,widget,event=None):
        self.searchitem = widget.get_text()
        #os.spawnvp(os.P_NOWAIT,"tracker-search-tool",["tracker-search-tool",self.searchitem])
        self.PGL.CallSpecialMenu(5,self.searchitem)
        
if __name__ == "__main__":
    hwg = Main_Menu()
    hwg.setup(0,0)
    gtk.main()
